<?php

header('Access-Control-Allow-Origin: *');
header('Access-Control-Allow-Methods: POST');
header('Access-Control-Allow-Headers: Content-Type');
header('Content-Type: application/json');

if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
    http_response_code(405); // Method Not Allowed
    echo json_encode(array('error' => 'Method Not Allowed. Please contact the Hostmasterweb developer team.'), JSON_PRETTY_PRINT);
    exit;
}


$whmcsUrl = 'https://portal.hostmasterweb.net';
$api_identifier = "YUPfPsjH8UJyVSotblaCTgy3AEM3OiPt";
$api_secret = "BarNXHbkGvQaqplyrwFkmyo2mCCgTPNp";

$message = "Reason: {$_POST['reason']}\n";
$message .= "Attachment Type: {$_POST['attachment_type']}\n";
$message .= "Organization Type: {$_POST['organizationtype']}\n";
$message .= "Organization Name: {$_POST['organization_name']}\n";
$message .= "Business Registration No: {$_POST['br_no']}\n";
$message .= "First Name: {$_POST['first_name']}\n";
$message .= "Last Name: {$_POST['last_name']}\n";
$message .= "Domain Name: {$_POST['domain_name']}\n";
$message .= "NIC/Passport: {$_POST['nic_number']}\n";
$message .= "Email Address: {$_POST['email']}\n";
$message .= "Phone Number: {$_POST['phone']}\n";
$message .= "Address: {$_POST['address']}\n";
$message .= "Country: {$_POST['country']}\n";
$message .= "Province: {$_POST['province']}\n";
$message .= "Reason Message: {$_POST['reason_message']}\n";

$subject = "LK Domain Registration Document for Domain Name: {$_POST['domain_name']}";

$postfields = array(
    'accesskey' => $api_secret,
    'username' => $api_identifier,
    'password' => $api_secret,
    'action' => 'OpenTicket',
    'responsetype' => 'json',
    'deptid' => '8',
    'priority' => 'Medium',
    'markdown' => true,
    'clientid' => $_POST['current_userId'],
    'name' => $_POST['current_name'],
    'email' => $_POST['current_email'],
    // 'email' => 'kawinduwijewardhane@gmail.com',
    'subject' => $subject,
    'message' => $message,
);

if (!empty($_FILES['document']['name'])) {
    $attachments = array();
    $attachmentName = $_FILES['document']['name'];
    $attachmentData = base64_encode(file_get_contents($_FILES['document']['tmp_name']));
    $attachments[] = array('name' => $attachmentName, 'data' => $attachmentData);
    $postfields['attachments'] = base64_encode(json_encode($attachments));
}

// Call the API
$ch = curl_init();
curl_setopt($ch, CURLOPT_URL, $whmcsUrl . 'includes/api.php');
curl_setopt($ch, CURLOPT_POST, 1);
curl_setopt($ch, CURLOPT_TIMEOUT, 30);
curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, 1);
curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, 2);
curl_setopt($ch, CURLOPT_POSTFIELDS, $postfields);
$response = curl_exec($ch);

if (curl_error($ch)) {
    $errorResponse = array('error' => 'Unable to connect to Hostmasterweb API. Please contact the Hostmasterweb developer team.');
    echo json_encode($errorResponse, JSON_PRETTY_PRINT);
    exit;
}

curl_close($ch);
$jsonData = json_decode($response, true);
echo json_encode($jsonData, JSON_PRETTY_PRINT);