<?php
/**
 * Domains.lk API Configuration
 * 
 * Keep this file secure and never commit it to version control with real API keys
 */

// API Configuration
define('DOMAINS_LK_API_BASE_URL', 'https://api.domains.lk');
define('DOMAINS_LK_API_KEY', 'ZYy4rRfjJRv52dQliBgmWtVnb6xdDN'); // Replace with your actual API key

// API Endpoints
define('DOMAINS_LK_ENDPOINT_SEARCH', '/searchdomain');
define('DOMAINS_LK_ENDPOINT_PROVISION', '/submitprovisionalorder');
define('DOMAINS_LK_ENDPOINT_API', '/api/');

// Default Country (if not provided)
define('DOMAINS_LK_DEFAULT_COUNTRY', 'Sri Lanka');

// Default Currency
define('DOMAINS_LK_DEFAULT_CURRENCY', 'LKR');

// File Upload Settings
define('DOMAINS_LK_MAX_FILE_SIZE', 2 * 1024 * 1024); // 2MB in bytes
define('DOMAINS_LK_ALLOWED_EXTENSIONS', ['jpg', 'jpeg', 'png', 'pdf']);

// DNS Record Settings
define('DOMAINS_LK_MAX_DNS_RECORDS', 8);
define('DOMAINS_LK_VALID_TTL_VALUES', [300, 3600, 7200, 14400, 28800, 57600, 86400, 172800, 345600, 604800, 1209600, 2419200]);
define('DOMAINS_LK_VALID_RR_TYPES', ['A', 'AAAA', 'CNAME', 'TXT']);

// Error Messages
define('DOMAINS_LK_ERROR_INVALID_API_KEY', 'Invalid API key');
define('DOMAINS_LK_ERROR_INVALID_DOMAIN', 'Invalid domain name');
define('DOMAINS_LK_ERROR_FILE_TOO_LARGE', 'File size exceeds maximum allowed size (2MB)');
define('DOMAINS_LK_ERROR_INVALID_FILE_TYPE', 'Invalid file type. Allowed: jpg, jpeg, png, pdf');

