<?php

// Allow requests from specific origins
$allowedOrigins = array(
    'https://hostmasterweb.net',
    'https://portal.hostmasterweb.net'
);

// Check if the request method is OPTIONS (preflight request)
if ($_SERVER['REQUEST_METHOD'] === 'OPTIONS') {
    if (isset($_SERVER['HTTP_ORIGIN']) && in_array($_SERVER['HTTP_ORIGIN'], $allowedOrigins)) {
        header("Access-Control-Allow-Origin: {$_SERVER['HTTP_ORIGIN']}");
        header('Access-Control-Allow-Methods: POST');
        header('Access-Control-Allow-Headers: Content-Type');
        header('Access-Control-Max-Age: 86400'); // Cache preflight request for 1 day
        header('Content-Length: 0');
        header('Content-Type: text/plain');
        header('HTTP/1.1 200 OK');
        exit;
    } else {
        header('HTTP/1.1 403 Forbidden');
        exit;
    }
}

// Allow requests from specific origins
if (isset($_SERVER['HTTP_ORIGIN']) && in_array($_SERVER['HTTP_ORIGIN'], $allowedOrigins)) {
    header("Access-Control-Allow-Origin: {$_SERVER['HTTP_ORIGIN']}");
    header('Access-Control-Allow-Methods: POST');
    header('Access-Control-Allow-Headers: Content-Type');
    header('Content-Type: application/json');

    if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
        http_response_code(405);
        echo json_encode(array('error' => 'Method Not Allowed. Please contact the Hostmasterweb developer team.'), JSON_PRETTY_PRINT);
        exit;
    }

    $whmcsUrl = 'https://portal.hostmasterweb.net/';
    $api_identifier = "YUPfPsjH8UJyVSotblaCTgy3AEM3OiPt";
    $api_secret = "BarNXHbkGvQaqplyrwFkmyo2mCCgTPNp";

    $postfields = array(
        'accesskey' => $api_secret,
        'username' => $api_identifier,
        'password' => $api_secret,
        'action' => 'GetTLDPricing',
        'currencyid' => '1',
        'responsetype' => 'json',
    );

    // Call the API
    $ch = curl_init();
    curl_setopt($ch, CURLOPT_URL, $whmcsUrl . 'includes/api.php');
    curl_setopt($ch, CURLOPT_POST, 1);
    curl_setopt($ch, CURLOPT_TIMEOUT, 30);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
    curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, 1);
    curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, 2);
    curl_setopt($ch, CURLOPT_POSTFIELDS, $postfields);
    $response = curl_exec($ch);

    if (curl_error($ch)) {
        $errorResponse = array('error' => 'Unable to connect to Hostmasterweb API. Please contact the Host Master Web LLC Developer team.');
        echo json_encode($errorResponse, JSON_PRETTY_PRINT);
        exit;
    }

    curl_close($ch);
    $jsonData = json_decode($response, true);
    echo json_encode($jsonData, JSON_PRETTY_PRINT);
} else {
    http_response_code(403);
    echo json_encode(array('error' => 'Access Forbidden. Origin not allowed.'), JSON_PRETTY_PRINT);
    exit;
}
